; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd,nf -verify-machineinstrs | FileCheck --check-prefix=NF %s
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd,nf -x86-enable-apx-for-relocation=true -verify-machineinstrs | FileCheck --check-prefix=NF %s

define i8 @inc8r(i8 noundef %a) {
; CHECK-LABEL: inc8r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incb %dil, %al
; CHECK-NEXT:    retq
;
; NF-LABEL: inc8r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incb %dil, %al
; NF-NEXT:    retq
entry:
  %inc = add i8 %a, 1
  ret i8 %inc
}

define i16 @inc16r(i16 noundef %a) {
; CHECK-LABEL: inc16r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incw %di, %ax
; CHECK-NEXT:    retq
;
; NF-LABEL: inc16r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incw %di, %ax
; NF-NEXT:    retq
entry:
  %inc = add i16 %a, 1
  ret i16 %inc
}

define i32 @inc32r(i32 noundef %a) {
; CHECK-LABEL: inc32r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incl %edi, %eax
; CHECK-NEXT:    retq
;
; NF-LABEL: inc32r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incl %edi, %eax
; NF-NEXT:    retq
entry:
  %inc = add i32 %a, 1
  ret i32 %inc
}

define i64 @inc64r(i64 noundef %a) {
; CHECK-LABEL: inc64r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incq %rdi, %rax
; CHECK-NEXT:    retq
;
; NF-LABEL: inc64r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incq %rdi, %rax
; NF-NEXT:    retq
entry:
  %inc = add i64 %a, 1
  ret i64 %inc
}

define i8 @inc8m(ptr %ptr) {
; CHECK-LABEL: inc8m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incb (%rdi), %al
; CHECK-NEXT:    retq
;
; NF-LABEL: inc8m:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incb (%rdi), %al
; NF-NEXT:    retq
entry:
  %a = load i8, ptr %ptr
  %inc = add i8 %a, 1
  ret i8 %inc
}

define i16 @inc16m(ptr %ptr) {
; CHECK-LABEL: inc16m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incw (%rdi), %ax
; CHECK-NEXT:    retq
;
; NF-LABEL: inc16m:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incw (%rdi), %ax
; NF-NEXT:    retq
entry:
  %a = load i16, ptr %ptr
  %inc = add i16 %a, 1
  ret i16 %inc
}

define i32 @inc32m(ptr %ptr) {
; CHECK-LABEL: inc32m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incl (%rdi), %eax
; CHECK-NEXT:    retq
;
; NF-LABEL: inc32m:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incl (%rdi), %eax
; NF-NEXT:    retq
entry:
  %a = load i32, ptr %ptr
  %inc = add i32 %a, 1
  ret i32 %inc
}

define i64 @inc64m(ptr %ptr) {
; CHECK-LABEL: inc64m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incq (%rdi), %rax
; CHECK-NEXT:    retq
;
; NF-LABEL: inc64m:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} incq (%rdi), %rax
; NF-NEXT:    retq
entry:
  %a = load i64, ptr %ptr
  %inc = add i64 %a, 1
  ret i64 %inc
}

define i8 @uinc8r(i8 noundef %a) {
; CHECK-LABEL: uinc8r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incb %dil, %al
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    movl $255, %ecx
; CHECK-NEXT:    cmovel %ecx, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq
;
; NF-LABEL: uinc8r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incb %dil, %al
; NF-NEXT:    movzbl %al, %eax
; NF-NEXT:    movl $255, %ecx
; NF-NEXT:    cmovel %ecx, %eax
; NF-NEXT:    # kill: def $al killed $al killed $eax
; NF-NEXT:    retq
entry:
  %inc = call i8 @llvm.uadd.sat.i8(i8 %a, i8 1)
  ret i8 %inc
}

define i16 @uinc16r(i16 noundef %a) {
; CHECK-LABEL: uinc16r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incw %di, %ax
; CHECK-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; CHECK-NEXT:    cmovel %ecx, %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
;
; NF-LABEL: uinc16r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incw %di, %ax
; NF-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; NF-NEXT:    cmovel %ecx, %eax
; NF-NEXT:    # kill: def $ax killed $ax killed $eax
; NF-NEXT:    retq
entry:
  %inc = call i16 @llvm.uadd.sat.i16(i16 %a, i16 1)
  ret i16 %inc
}

define i32 @uinc32r(i32 noundef %a) {
; CHECK-LABEL: uinc32r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incl %edi, %eax
; CHECK-NEXT:    movl $-1, %ecx
; CHECK-NEXT:    cmovel %ecx, %eax
; CHECK-NEXT:    retq
;
; NF-LABEL: uinc32r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incl %edi, %eax
; NF-NEXT:    movl $-1, %ecx
; NF-NEXT:    cmovel %ecx, %eax
; NF-NEXT:    retq
entry:
  %inc = call i32 @llvm.uadd.sat.i32(i32 %a, i32 1)
  ret i32 %inc
}

define i64 @uinc64r(i64 noundef %a) {
; CHECK-LABEL: uinc64r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incq %rdi, %rax
; CHECK-NEXT:    movq $-1, %rcx
; CHECK-NEXT:    cmoveq %rcx, %rax
; CHECK-NEXT:    retq
;
; NF-LABEL: uinc64r:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incq %rdi, %rax
; NF-NEXT:    movq $-1, %rcx
; NF-NEXT:    cmoveq %rcx, %rax
; NF-NEXT:    retq
entry:
  %inc = call i64 @llvm.uadd.sat.i64(i64 %a, i64 1)
  ret i64 %inc
}

declare i8 @llvm.uadd.sat.i8(i8, i8)
declare i16 @llvm.uadd.sat.i16(i16, i16)
declare i32 @llvm.uadd.sat.i32(i32, i32)
declare i64 @llvm.uadd.sat.i64(i64, i64)

define void @inc8m_legacy(ptr %ptr) {
; CHECK-LABEL: inc8m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incb (%rdi)
; CHECK-NEXT:    retq
;
; NF-LABEL: inc8m_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incb (%rdi)
; NF-NEXT:    retq
entry:
  %a = load i8, ptr %ptr
  %inc = add i8 %a, 1
  store i8 %inc, ptr %ptr
  ret void
}

define void @inc16m_legacy(ptr %ptr) {
; CHECK-LABEL: inc16m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incw (%rdi)
; CHECK-NEXT:    retq
;
; NF-LABEL: inc16m_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incw (%rdi)
; NF-NEXT:    retq
entry:
  %a = load i16, ptr %ptr
  %inc = add i16 %a, 1
  store i16 %inc, ptr %ptr
  ret void
}

define void @inc32m_legacy(ptr %ptr) {
; CHECK-LABEL: inc32m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incl (%rdi)
; CHECK-NEXT:    retq
;
; NF-LABEL: inc32m_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incl (%rdi)
; NF-NEXT:    retq
entry:
  %a = load i32, ptr %ptr
  %inc = add i32 %a, 1
  store i32 %inc, ptr %ptr
  ret void
}

define void @inc64m_legacy(ptr %ptr) {
; CHECK-LABEL: inc64m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    incq (%rdi)
; CHECK-NEXT:    retq
;
; NF-LABEL: inc64m_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    incq (%rdi)
; NF-NEXT:    retq
entry:
  %a = load i64, ptr %ptr
  %inc = add i64 %a, 1
  store i64 %inc, ptr %ptr
  ret void
}
