dnl Licensed under the Apache License, Version 2.0 (the "License");
dnl you may not use this file except in compliance with the License.
dnl You may obtain a copy of the License at
dnl 
dnl     http://www.apache.org/licenses/LICENSE-2.0
dnl 
dnl Unless required by applicable law or agreed to in writing, software
dnl distributed under the License is distributed on an "AS IS" BASIS,
dnl WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
dnl See the License for the specific language governing permissions and
dnl limitations under the License.
dnl 
dnl Authors:
dnl 2010-
dnl     Oscar Koeroo <okoeroo@nikhef.nl>
dnl     Mischa Sall\'e <msalle@nikhef.nl>
dnl     NIKHEF Amsterdam, the Netherlands
dnl
dnl Usage: AC_LCAS or AC_LCAS([sub-component]) or AC_LCAS_INTERFACE
dnl  sets *_CFLAGS and *_LIBS

AC_DEFUN([AC_LCAS],
[
    dnl Make sure autoconf (bootstrap) fails when macro is undefined
    ifdef([PKG_CHECK_MODULES],
          [],
          [m4_fatal([macro PKG_CHECK_MODULES is not defined])])

    AC_LCAS_CONFIG_FLAGS

    dnl For lcas itself (not just interface) add libdir option.
    AC_ARG_WITH([lcas-libdir],
		[AC_HELP_STRING([--with-lcas-libdir=DIR],
		    [Directory where LCAS libraries are installed (default either LCAS-PREFIX/lib or LCAS-PREFIX/lib64)])],
		[ac_lcas_libdir=$withval],
		[])

    dnl Check for gsi mode
    enable_lcas_gsi_mode_default=yes
    AC_ARG_ENABLE([lcas-gsi-mode],
		  [AC_HELP_STRING([--enable-lcas-gsi-mode],
		    [use lcas flavour that provides a GSI interface (default)])],
		  [enable_lcas_gsi_mode=$enableval],
		  [enable_lcas_gsi_mode=$enable_lcas_gsi_mode_default])

    dnl check different modules, depending on gsi-mode/LCAS_FLAVOUR
    if test "x$enable_lcas_gsi_mode" = "xyes" ; then
	dnl only run GSSAPI_GSI check when we haven't done so before
	if test "x$have_globus_gssapi_gsi" = "x" ; then
	    AC_GLOBUS([GSSAPI_GSI],[],AC_MSG_WARN(["missing dependency gssapi-gsi"]))
	fi
	dnl only test lcas when we have globus_gssapi_gsi
	if test "x$have_globus_gssapi_gsi" = "xyes" ; then
	    LCAS_FLAVOUR=""
	    AC_DEFINE(LCAS_GSI_MODE, 1, "If defined provide the GSI interface to LCAS")
	    dnl Always test for basic LCAS
	    AC_LCAS_MODULE([lcas])
	    dnl IF we have lcas, now test for secondary libraries
dnl	    if test "x$have_lcas" = "xyes" ; then
dnl		dnl If an argument was given: test only that library, otherwise check all
dnl		ifelse([$1],[],[
dnl		    AC_LCAS_MODULE([lcas-pem])
dnl		],[
dnl		    AC_LCAS_MODULE($1)
dnl		])
dnl	    fi
	else
	    have_lcas=no
	fi
    else
	LCAS_FLAVOUR="_without_gsi"
	dnl Always test for basic LCAS-without-gsi
	AC_LCAS_MODULE([lcas-without-gsi])
	dnl IF we have lcas-without-gsi, test for secondary libraries
dnl	if test "x$have_lcas_without_gsi" = "xyes" ; then
dnl	    dnl If an argument was given: test only that library, otherwise check all
dnl	    ifelse([$1],[],[
dnl		AC_LCAS_MODULE([lcas-pem-without-gsi])
dnl	    ],[
dnl		AC_LCAS_MODULE($1-without-gsi)
dnl	    ])
dnl	fi
    fi
    
    AM_CONDITIONAL(LCAS_GSI_MODE, test x$enable_lcas_gsi_mode = xyes)
])

AC_DEFUN([AC_LCAS_INTERFACE],
[
    AC_LCAS_CONFIG_FLAGS

    if test "x$with_lcas_prefix" = "x" -a "x$with_lcas_includes" = "x" ; then
	PKG_CHECK_MODULES(LCAS_INTERFACE, lcas-interface,
			  have_lcas_interface=yes, have_lcas_interface=no)
	if test "$have_lcas_interface" = "no" ; then
	    LCAS_DIRECT_CHECK_INTERFACE(LCAS_INTERFACE,
					  have_lcas_interface=yes, have_lcas_interface=no)
	fi
    else
	LCAS_DIRECT_CHECK_INTERFACE(LCAS_INTERFACE,
	    have_lcas_interface=yes, have_lcas_interface=no)
	if test "$have_lcas_interface" = "no" ; then
	    PKG_CHECK_MODULES(LCAS_INTERFACE, lcas-interface,
			      have_lcas_interface=yes, have_lcas_interface=no)
	fi
    fi

    LCAS_CFLAGS=$LCAS_INTERFACE_CFLAGS
    AC_SUBST(LCAS_INTERFACE_CFLAGS)
    AC_SUBST(LCAS_CFLAGS)
])

AC_DEFUN([AC_LCAS_CONFIG_FLAGS],
[
    AC_ARG_WITH([lcas-prefix],
		[AC_HELP_STRING([--with-lcas-prefix=DIR],
		    [Prefix where LCAS is installed (default /usr)])],
		[ac_lcas_prefix=$withval],
		[ac_lcas_prefix=/usr])

    AC_ARG_WITH([lcas-includes],
		[AC_HELP_STRING([--with-lcas-includes=DIR],
		    [Directory where LCAS headers are installed (default LCAS-PREFIX/include)])],
		[ac_lcas_includes=$withval],
		[ac_lcas_includes=$ac_lcas_prefix/include])

])    

AC_DEFUN([AC_LCAS_MODULE],
[
    if test "x$with_lcas_prefix" = "x" ; then
	PKG_CHECK_MODULES(translit($1,[a-z-],[A-Z_]), $1,
			  have_lcas_mod=yes, have_lcas_mod=no)
	if test "$have_lcas_mod" = "no" ; then
	    LCAS_DIRECT_CHECK_MODULES(translit($1,[a-z-],[A-Z_]),translit($1,[-],[_]),
					have_lcas_mod=yes, have_lcas_mod=no)
	fi
    else
	LCAS_DIRECT_CHECK_MODULES(translit($1,[a-z-],[A-Z_]), translit($1,[-],[_]),
				    have_lcas_mod=yes, have_lcas_mod=no)
	if test "$have_lcas_mod" = "no" ; then
	    PKG_CHECK_MODULES(translit($1,[a-z-],[A-Z_]), $1,
			      have_lcas_mod=yes, have_lcas_mod=no)
	fi
    fi
    [have_]translit($1,[-],[_])=$have_lcas_mod

    AC_SUBST(translit($1,[a-z-],[A-Z_])_CFLAGS)
    AC_SUBST(translit($1,[a-z-],[A-Z_])_LIBS)

])

AC_DEFUN([LCAS_DIRECT_CHECK_MODULES],
[
    ac_save_LIBS=$LIBS
    ac_save_CFLAGS=$CFLAGS

    if test "x$ac_lcas_includes" != "x" ; then
	ac_try_CFLAGS="-I$ac_lcas_includes"
    fi

    if test "x$2" != "xlcas" -a "x$2" != "xlcas_without_gsi" ; then
	ac_lcas_extralibs="-llcas$LCAS_FLAVOUR"
    else
	ac_lcas_extralibs=""
    fi

    if test "x$LCAS_FLAVOUR" = "x" ; then
	ac_lcas_extralibs="$GLOBUS_GSSAPI_GSI_NOTHR_LIBS $ac_lcas_extralibs"
	ac_lcas_extralibs="$GLOBUS_GSSAPI_GSI_LIBS $ac_lcas_extralibs"
	ac_lcas_extralibs="$GLOBUS_GSS_ASSIST_NOTHR_LIBS $ac_lcas_extralibs"
	ac_lcas_extralibs="$GLOBUS_GSS_ASSIST_LIBS $ac_lcas_extralibs"
	ac_lcas_extralibs="$GLOBUS_GSI_CERT_UTILS_NOTHR_LIBS $ac_lcas_extralibs"
	ac_lcas_extralibs="$GLOBUS_GSI_CERT_UTILS_LIBS $ac_lcas_extralibs"
    fi

    # check whether we have specified lcas-libdir or lcas-prefix
    if test "x$with_lcas_libdir" != "x" -o "x$with_lcas_prefix" != "x" ; then
	# If we haven't determined a libdir, do it now from prefix
	if test "x$ac_lcas_libdir" = "x" ; then
	    if test "x$host_cpu" = "xx86_64" \
	     -a -e $ac_lcas_prefix/lib64 \
	     -a ! -h $ac_lcas_prefix/lib64 ; then
		ac_lcas_libdir="$ac_lcas_prefix/lib64"
	    else
		ac_lcas_libdir="$ac_lcas_prefix/lib"
	    fi
	fi

	if test "x$LCAS_FLAVOUR" = "x" -a "x$ac_globus_libdir" != "x" ; then
	    ac_lcas_libpath="$ac_globus_libdir:$ac_lcas_libdir"
	else
	    ac_lcas_libpath="$ac_lcas_libdir"
	fi

	ac_try_LIBS="-L$ac_lcas_libdir -l$2 $ac_lcas_extralibs"
	AC_MSG_CHECKING([for $1 at system default and $ac_lcas_libdir])
    else
	if test "x$LCAS_FLAVOUR" = "x" -a "x$ac_globus_libdir" != "x" ; then
	    ac_lcas_libpath="$ac_globus_libdir"
	else
	    ac_lcas_libpath=""
	fi

	ac_try_LIBS="-l$2 $ac_lcas_extralibs"
	AC_MSG_CHECKING([for $1 at system default])
    fi

    if test "x$ac_lcas_libpath" != "x" ; then 
	if test "x$LD_LIBRARY_PATH" != "x" ; then
            ac_save_LD_LIBRARY_PATH=$LD_LIBRARY_PATH
            export LD_LIBRARY_PATH="$ac_lcas_libpath:$LD_LIBRARY_PATH"
        else
            export LD_LIBRARY_PATH="$ac_lcas_libpath"
        fi

        if test "x$DYLD_LIBRARY_PATH" != "x" ; then
            ac_save_DYLD_LIBRARY_PATH=$DYLD_LIBRARY_PATH
            export DYLD_LIBRARY_PATH="$ac_lcas_libpath:$DYLD_LIBRARY_PATH"
        else
            export DYLD_LIBRARY_PATH="$ac_lcas_libpath"
        fi
    fi

    dnl We want to add the cmdline specified CFLAGS and LIBS, but only for
    dnl checking, not to the *_CFLAGS etc.
    CFLAGS="$ac_try_CFLAGS $CFLAGS"
    LIBS="$ac_try_LIBS $LIBS"
    AC_LINK_IFELSE([AC_LANG_SOURCE( [#include <lcas/lcas_log.h>
		     int main(void) {return 0;}] )],
                    [have_mod=yes], [have_mod=no])
    AC_MSG_RESULT([$have_mod])

    if test "x$have_mod" = "xyes" ; then
	[$3]
	$1_CFLAGS=$ac_try_CFLAGS
	$1_LIBS="$ac_try_LIBS"
    else
	[$4]
	$1_CFLAGS=""
	$1_LIBS=""
    fi

    CFLAGS=$ac_save_CFLAGS
    CPPFLAGS=$ac_save_CPPFLAGS
    LIBS=$ac_save_LIBS

    if test "x$ac_save_LD_LIBRARY_PATH" = "x" ; then
	unset LD_LIBRARY_PATH
    else
	LD_LIBRARY_PATH=$ac_save_LD_LIBRARY_PATH
    fi
    if test "x$ac_save_DYLD_LIBRARY_PATH" = "x" ; then
	unset DYLD_LIBRARY_PATH
    else
	DYLD_LIBRARY_PATH=$ac_save_DYLD_LIBRARY_PATH
    fi
    if test "x$ac_save_LD_LIBRARY_PATH" = "x" ; then
        unset LD_LIBRARY_PATH
    else
        LD_LIBRARY_PATH=$ac_save_LD_LIBRARY_PATH
    fi
    if test "x$ac_save_DYLD_LIBRARY_PATH" = "x" ; then
        unset DYLD_LIBRARY_PATH
    else
        DYLD_LIBRARY_PATH=$ac_save_DYLD_LIBRARY_PATH
    fi

])

AC_DEFUN([LCAS_DIRECT_CHECK_INTERFACE],
[
    ac_save_CFLAGS=$CFLAGS

    if test "x$ac_lcas_includes" != "x" ; then
	ac_try_CFLAGS="-I$ac_lcas_includes"
    fi

    if test "x$ac_lcas_includes" != "x" ; then
	AC_MSG_CHECKING([for $1 at system default and $ac_lcas_includes])
    else
	AC_MSG_CHECKING([for $1 at system default])
    fi

    dnl We want to add the cmdline specified CFLAGS, but only for dnl checking,
    dnl not to the *_CFLAGS.
    CFLAGS="$ac_try_CFLAGS $CFLAGS"
    AC_COMPILE_IFELSE([AC_LANG_SOURCE( [#include <lcas/lcas_log.h>
		        int main(void) {return 0;}] )],
			[have_mod=yes], [have_mod=no])
    AC_MSG_RESULT([$have_mod])

    if test "x$have_mod" = "xyes" ; then
	[$2]
	$1_CFLAGS=$ac_try_CFLAGS
    else
	[$3]
	$1_CFLAGS=""
    fi

    CFLAGS=$ac_save_CFLAGS
    
])
