#!/bin/sh

THIS_DIR=`dirname "$0"`
BASE_DIR="$THIS_DIR/.."

STORE_TYPE=${STORE_TYPE:-file}

if [ "$STORE_TYPE" = "file" ]; then
    STORE=/tmp/store
    JOURNAL=/tmp/journal
elif [ "$STORE_TYPE" = "postgresql" ]; then
    DBNAME='imip_agent_test'
    STORE="dbname=$DBNAME"
    JOURNAL="$STORE"
fi

STATIC=/tmp/static
PREFS=/tmp/prefs

ARGS="-T $STORE_TYPE -S $STORE -P $STATIC -p $PREFS -j $JOURNAL -d"

RESOURCE_SCRIPT="$BASE_DIR/imip_resource.py"

SHOWMAIL="$BASE_DIR/tools/showmail.py"

TEMPLATES="$THIS_DIR/templates"

ERROR=err.tmp

DBERROR=dberr.tmp
