# Print packages required by given package, set using legacy dependencies system.
# USAGE: dependencies_legacy_list $package
dependencies_legacy_list() {
	local package
	package="$1"

	local dependencies_legacy
	dependencies_legacy=$(context_value "${package}_DEPS")
	# Return early if current package does not use legacy dependencies.
	if [ -z "$dependencies_legacy" ]; then
		return 0
	fi

	if compatibility_level_is_at_least '2.30'; then
		warning_deprecated_variable "${package}_DEPS" "${package}_DEPENDENCIES_xxx"
	fi

	printf '%s' "$dependencies_legacy" | sed 's/ /\n/g' | list_clean
}

# Print native packages required by given package, set using legacy dependencies system.
# USAGE: dependencies_legacy_list_packages $package
dependencies_legacy_list_packages() {
	local package
	package="$1"

	local dependencies_legacy
	dependencies_legacy=$(dependencies_legacy_list "$package")
	# Return early if current package does not use legacy dependencies.
	if [ -z "$dependencies_legacy" ]; then
		return 0
	fi

	local option_package dependencies_packages
	option_package=$(option_value 'package')
	case "$option_package" in
		('arch')
			dependencies_packages=$(dependencies_legacy_list_archlinux "$dependencies_legacy")
		;;
		('deb')
			dependencies_packages=$(dependencies_legacy_list_debian "$dependencies_legacy")
		;;
		('gentoo')
			dependencies_packages=$(dependencies_legacy_list_gentoo "$dependencies_legacy")
		;;
	esac

	printf '%s' "$dependencies_packages" | list_clean
}

