// Boost.Geometry
// Unit Test

// Copyright (c) 2016-2018 Oracle and/or its affiliates.

// Contributed and/or modified by Vissarion Fysikopoulos, on behalf of Oracle
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_TEST_DIRECT_CASES_HPP
#define BOOST_GEOMETRY_TEST_DIRECT_CASES_HPP

struct coordinates
{
    double lon;
    double lat;
};

struct expected_result
{
    double lon2;
    double lat2;
    double reverse_azimuth;
    double reduced_length;
    double geodesic_scale;
};

struct expected_results
{
    coordinates p1;
    double distance;
    double azimuth12;
    expected_result karney;
    expected_result vincenty;
    expected_result thomas;
    expected_result thomas1st;
    expected_result series;
    expected_result spherical;
};

expected_results expected[] =
{

        {
            { 0, 0 }, 250000, 0,
            { 0.00000000000000000000, 2.26091191238511868278, 0.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { 0.00000000000000000000, 2.26091191236402178077, 0.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { 0.00000000000000000000, 2.26091189386641744363, 0.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { 0.00000000000000000000, 2.26091190837723177154, 0.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { 0.00000000000000000000, 2.26091191238508226746, 0.00000000000000000000, 249935.55905602785060182214, 0.99922674639115527384 },
            { 0.00000000000000000000, 2.24830091939884413321, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, 45,
            { 1.58842150169031337548, 1.59850419267109766785, 45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
            { 1.58842150168977558344, 1.59850419267017707092, 45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
            { 1.58842149958854261804, 1.59850419056543535667, 45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 },
            { 1.58842150075770360829, 1.59850419406187715943, 45.02216068947401339528, 249935.55908163820276968181, 0.99922674504700181863 },
            { 1.58842150169031270934, 1.59850419267109744581, 45.02216068943543092473, 249935.55885453775408677757, 0.99922674504834751996 },
            { 1.59019688120571478507, 1.58958477520588337129, 45.02206163500609648054, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, 90,
            { 2.24578821029880382198, 0.00000000000000000000, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 2.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 2.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 2.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 2.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 2.24830091939884413321, 0.00000000000000013763, 90.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, 135,
            { 1.58842150169031337548, -1.59850419267109766785, 134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
            { 1.58842150168977580549, -1.59850419267017707092, 134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
            { 1.58842149958854261804, -1.59850419056543602281, 134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 },
            { 1.58842150075770360829, -1.59850419406187760352, 134.97783931052597949929, 249935.55908163831918500364, 0.99922674504700181863 },
            { 1.58842150169033402562, -1.59850419267108945220, 134.97783931056457618070, 249935.55885453653172589839, 0.99922674504834751996 },
            { 1.59019688120571345280, -1.58958477520588448151, 134.97793836499391773032, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, 180,
            { 0.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { 0.00000000000000027517, -2.26091191236402178077, 180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { 0.00000000000000000000, -2.26091189386641744363, 180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { 0.00000000000000000000, -2.26091190837723177154, 180.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { 0.00000000000000000000, -2.26091191238511468597, 180.00000000000000000000, 249935.55905603148858062923, 0.99922674639115527384 },
            { 0.00000000000000000000, -2.24830091939884635366, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, -45,
            { -1.58842150169031337548, 1.59850419267109766785, -45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
            { -1.58842150168977558344, 1.59850419267017707092, -45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
            { -1.58842149958854261804, 1.59850419056543535667, -45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 },
            { -1.58842150075770360829, 1.59850419406187715943, -45.02216068947401339528, 249935.55908163820276968181, 0.99922674504700181863 },
            { -1.58842150169031270934, 1.59850419267109744581, -45.02216068943543092473, 249935.55885453775408677757, 0.99922674504834751996 },
            { -1.59019688120571478507, 1.58958477520588337129, -45.02206163500609648054, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, -90,
            { -2.24578821029880382198, 0.00000000000000000000, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -2.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -2.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -2.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -2.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -2.24830091939884413321, 0.00000000000000013763, -90.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, -135,
            { -1.58842150169031337548, -1.59850419267109766785, -134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
            { -1.58842150168977580549, -1.59850419267017707092, -134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
            { -1.58842149958854261804, -1.59850419056543602281, -134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 },
            { -1.58842150075770360829, -1.59850419406187760352, -134.97783931052597949929, 249935.55908163831918500364, 0.99922674504700181863 },
            { -1.58842150169033402562, -1.59850419267108945220, -134.97783931056457618070, 249935.55885453653172589839, 0.99922674504834751996 },
            { -1.59019688120571345280, -1.58958477520588448151, -134.97793836499391773032, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 0 }, 250000, -180,
            { 0.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { -0.00000000000000027517, -2.26091191236402178077, -180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { 0.00000000000000000000, -2.26091189386641744363, -180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { 0.00000000000000000000, -2.26091190837723177154, -180.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { 0.00000000000000000000, -2.26091191238511468597, -180.00000000000000000000, 249935.55905603148858062923, 0.99922674639115527384 },
            { 0.00000000000000000000, -2.24830091939884635366, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, 0,
            { -1.00000000000000000000, 2.26091191238511868278, 0.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { -1.00000000000000000000, 2.26091191236402178077, 0.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { -1.00000000000000000000, 2.26091189386641744363, 0.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { -1.00000000000000000000, 2.26091190837723177154, 0.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { -1.00000000000000000000, 2.26091191238508226746, 0.00000000000000000000, 249935.55905602785060182214, 0.99922674639115527384 },
            { -1.00000000000000000000, 2.24830091939884413321, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, 45,
            { 0.58842150169031337548, 1.59850419267109766785, 45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
            { 0.58842150168977558344, 1.59850419267017707092, 45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
            { 0.58842149958854272906, 1.59850419056543535667, 45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 },
            { 0.58842150075770371931, 1.59850419406187715943, 45.02216068947401339528, 249935.55908163820276968181, 0.99922674504700181863 },
            { 0.58842150169031270934, 1.59850419267109744581, 45.02216068943543092473, 249935.55885453775408677757, 0.99922674504834751996 },
            { 0.59019688120571467405, 1.58958477520588337129, 45.02206163500609648054, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, 90,
            { 1.24578821029880382198, 0.00000000000000000000, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 1.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 1.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 1.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 1.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 1.24830091939884435526, 0.00000000000000013763, 90.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, 135,
            { 0.58842150169031337548, -1.59850419267109766785, 134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
            { 0.58842150168977569447, -1.59850419267017707092, 134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
            { 0.58842149958854272906, -1.59850419056543602281, 134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 },
            { 0.58842150075770371931, -1.59850419406187760352, 134.97783931052597949929, 249935.55908163831918500364, 0.99922674504700181863 },
            { 0.58842150169033402562, -1.59850419267108945220, 134.97783931056457618070, 249935.55885453653172589839, 0.99922674504834751996 },
            { 0.59019688120571345280, -1.58958477520588448151, 134.97793836499391773032, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, 180,
            { -1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { -0.99999999999999977796, -2.26091191236402178077, 180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { -1.00000000000000000000, -2.26091189386641744363, 180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { -1.00000000000000000000, -2.26091190837723177154, 180.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { -1.00000000000000000000, -2.26091191238511468597, 180.00000000000000000000, 249935.55905603148858062923, 0.99922674639115527384 },
            { -1.00000000000000000000, -2.24830091939884635366, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, -45,
            { -2.58842150169031359752, 1.59850419267109766785, -45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
            { -2.58842150168977536140, 1.59850419267017707092, -45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
            { -2.58842149958854284009, 1.59850419056543535667, -45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 },
            { -2.58842150075770360829, 1.59850419406187715943, -45.02216068947401339528, 249935.55908163820276968181, 0.99922674504700181863 },
            { -2.58842150169031270934, 1.59850419267109744581, -45.02216068943543092473, 249935.55885453775408677757, 0.99922674504834751996 },
            { -2.59019688120571478507, 1.58958477520588337129, -45.02206163500609648054, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, -90,
            { -3.24578821029880382198, 0.00000000000000000000, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -3.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { -3.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { -3.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { -3.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { -3.24830091939884457730, 0.00000000000000013763, -90.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, -135,
            { -2.58842150169031359752, -1.59850419267109766785, -134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
            { -2.58842150168977580549, -1.59850419267017707092, -134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
            { -2.58842149958854284009, -1.59850419056543602281, -134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 },
            { -2.58842150075770360829, -1.59850419406187760352, -134.97783931052597949929, 249935.55908163831918500364, 0.99922674504700181863 },
            { -2.58842150169027718221, -1.59850419267108945220, -134.97783931056457618070, 249935.55885453653172589839, 0.99922674504834751996 },
            { -2.59019688120571345280, -1.58958477520588448151, -134.97793836499391773032, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 0 }, 250000, -180,
            { -1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { -1.00000000000000022204, -2.26091191236402178077, -180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { -1.00000000000000000000, -2.26091189386641744363, -180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { -1.00000000000000000000, -2.26091190837723177154, -180.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { -1.00000000000000000000, -2.26091191238511468597, -180.00000000000000000000, 249935.55905603148858062923, 0.99922674639115527384 },
            { -1.00000000000000000000, -2.24830091939884635366, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, 0,
            { 1.00000000000000000000, 2.26091191238511868278, 0.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { 1.00000000000000000000, 2.26091191236402178077, 0.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { 1.00000000000000000000, 2.26091189386641744363, 0.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { 1.00000000000000000000, 2.26091190837723177154, 0.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { 1.00000000000000000000, 2.26091191238508226746, 0.00000000000000000000, 249935.55905602785060182214, 0.99922674639115527384 },
            { 1.00000000000000000000, 2.24830091939884413321, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, 45,
            { 2.58842150169031359752, 1.59850419267109766785, 45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
            { 2.58842150168977536140, 1.59850419267017707092, 45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
            { 2.58842149958854284009, 1.59850419056543535667, 45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 },
            { 2.58842150075770360829, 1.59850419406187715943, 45.02216068947401339528, 249935.55908163820276968181, 0.99922674504700181863 },
            { 2.58842150169031270934, 1.59850419267109744581, 45.02216068943543092473, 249935.55885453775408677757, 0.99922674504834751996 },
            { 2.59019688120571478507, 1.58958477520588337129, 45.02206163500609648054, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, 90,
            { 3.24578821029880382198, 0.00000000000000000000, 90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { 3.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { 3.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { 3.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { 3.24578821029880382198, 0.00000000000000013841, 90.00000000000000000000, 249935.55865304192411713302, 0.99922674370552955203 },
            { 3.24830091939884457730, 0.00000000000000013763, 90.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, 135,
            { 2.58842150169031359752, -1.59850419267109766785, 134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
            { 2.58842150168977580549, -1.59850419267017707092, 134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
            { 2.58842149958854284009, -1.59850419056543602281, 134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 },
            { 2.58842150075770360829, -1.59850419406187760352, 134.97783931052597949929, 249935.55908163831918500364, 0.99922674504700181863 },
            { 2.58842150169027718221, -1.59850419267108945220, 134.97783931056457618070, 249935.55885453653172589839, 0.99922674504834751996 },
            { 2.59019688120571345280, -1.58958477520588448151, 134.97793836499391773032, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, 180,
            { 1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { 1.00000000000000022204, -2.26091191236402178077, 180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { 1.00000000000000000000, -2.26091189386641744363, 180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { 1.00000000000000000000, -2.26091190837723177154, 180.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { 1.00000000000000000000, -2.26091191238511468597, 180.00000000000000000000, 249935.55905603148858062923, 0.99922674639115527384 },
            { 1.00000000000000000000, -2.24830091939884635366, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, -45,
            { -0.58842150169031337548, 1.59850419267109766785, -45.02216068943542381930, 249935.55885449703782796860, 0.99922674504834751996 },
            { -0.58842150168977558344, 1.59850419267017707092, -45.02216068943540250302, 249935.55886070139240473509, 0.99922674504834840814 },
            { -0.58842149958854272906, 1.59850419056543535667, -45.02216068937701010100, 249935.55853169565671123564, 0.99922674505038500126 },
            { -0.58842150075770371931, 1.59850419406187715943, -45.02216068947401339528, 249935.55908163820276968181, 0.99922674504700181863 },
            { -0.58842150169031270934, 1.59850419267109744581, -45.02216068943543092473, 249935.55885453775408677757, 0.99922674504834751996 },
            { -0.59019688120571467405, 1.58958477520588337129, -45.02206163500609648054, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, -90,
            { -1.24578821029880382198, 0.00000000000000000000, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -1.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -1.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -1.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -1.24578821029880382198, 0.00000000000000013841, -90.00000000000000000000, 249935.55865304186590947211, 0.99922674370552955203 },
            { -1.24830091939884435526, 0.00000000000000013763, -90.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, -135,
            { -0.58842150169031337548, -1.59850419267109766785, -134.97783931056457618070, 249935.55885449703782796860, 0.99922674504834751996 },
            { -0.58842150168977569447, -1.59850419267017707092, -134.97783931056460460240, 249935.55886070139240473509, 0.99922674504834840814 },
            { -0.58842149958854272906, -1.59850419056543602281, -134.97783931062298279357, 249935.55853169583133421838, 0.99922674505038500126 },
            { -0.58842150075770371931, -1.59850419406187760352, -134.97783931052597949929, 249935.55908163831918500364, 0.99922674504700181863 },
            { -0.58842150169033402562, -1.59850419267108945220, -134.97783931056457618070, 249935.55885453653172589839, 0.99922674504834751996 },
            { -0.59019688120571345280, -1.58958477520588448151, -134.97793836499391773032, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 0 }, 250000, -180,
            { 1.00000000000000000000, -2.26091191238511868278, -180.00000000000000000000, 249935.55905595037620514631, 0.99922674639115516282 },
            { 0.99999999999999977796, -2.26091191236402178077, -180.00000000000000000000, 249935.55905951990280300379, 0.99922674639116959572 },
            { 1.00000000000000000000, -2.26091189386641744363, -180.00000000000000000000, 249935.55701571033569052815, 0.99922674640382092015 },
            { 1.00000000000000000000, -2.26091190837723177154, -180.00000000000000000000, 249935.55863258230965584517, 0.99922674639389641449 },
            { 1.00000000000000000000, -2.26091191238511468597, -180.00000000000000000000, 249935.55905603148858062923, 0.99922674639115527384 },
            { 1.00000000000000000000, -2.24830091939884635366, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, 0,
            { 0.00000000000000000000, 1.26092062918498104551, 0.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { 0.00000000000000000000, 1.26092062916373448545, 0.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { 0.00000000000000000000, 1.26092061053506587776, 0.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { 0.00000000000000000000, 1.26092062023552875516, 0.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { 0.00000000000000000000, 1.26092062918495995127, 0.00000000000000000000, 249935.55872469596215523779, 0.99922674479230122468 },
            { 0.00000000000000000000, 1.24830091939884435526, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, 45,
            { 1.58789352027561725400, 0.59889382252477618707, 44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
            { 1.58789352027508279264, 0.59889382252384637528, 44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
            { 1.58789351816042789700, 0.59889382039736038799, 44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 },
            { 1.58789351933467837164, 0.59889382227058296504, 44.99444098733723507166, 249935.55866038752719759941, 0.99922674484142481877 },
            { 1.58789352027561680991, 0.59889382252477563195, 44.99444098733987829064, 249935.55869721624185331166, 0.99922674484119011762 },
            { 1.58966906957485254459, 0.58996975014221642031, 44.99431096332273227745, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, 90,
            { 2.24612766651409989649, -0.99922666842209439952, 89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
            { 2.24612766651347328661, -0.99922666842209439952, 89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
            { 2.24612766651409945240, -0.99922666842208529570, 89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 },
            { 2.24612766651409812013, -0.99922666841944873806, 89.96080977143354573400, 249935.55934300241642631590, 0.99922674685495815883 },
            { 2.24612766651407858021, -0.99922666842209184601, 89.96080977150054991398, 249935.55891566007630899549, 0.99922674685767387537 },
            { 2.24864304714222296155, -0.99923012194947846698, 89.96076583819413485799, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, 135,
            { 1.58943065821228057821, -2.59810442478829362045, 134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
            { 1.58943065821171258811, -2.59810442478739078709, 134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
            { 1.58943065613921019619, -2.59810442273856878614, 134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 },
            { 1.58943065729835319999, -2.59810443328209572655, 134.95009296210329807764, 249935.56090466637397184968, 0.99922675155085038945 },
            { 1.58943065821226814371, -2.59810442478831138402, 134.95009296248679220298, 249935.55953712956397794187, 0.99922675155892148879 },
            { 1.59120965314639395416, -2.58919942720575324557, 134.95016080642784572774, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, 180,
            { 0.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { 0.00000000000000027540, -3.26088938009322193423, 180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { 0.00000000000000000000, -3.26088936183515265554, 180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { 0.00000000000000000000, -3.26088938879229361945, 180.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { 0.00000000000000000000, -3.26088938011400975014, 180.00000000000000000000, 249935.55991249711951240897, 0.99922675429255336521 },
            { 0.00000000000000000000, -3.24830091939884901819, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, -45,
            { -1.58789352027561725400, 0.59889382252477618707, -44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
            { -1.58789352027508279264, 0.59889382252384637528, -44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
            { -1.58789351816042789700, 0.59889382039736038799, -44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 },
            { -1.58789351933467837164, 0.59889382227058296504, -44.99444098733723507166, 249935.55866038752719759941, 0.99922674484142481877 },
            { -1.58789352027561680991, 0.59889382252477563195, -44.99444098733987829064, 249935.55869721624185331166, 0.99922674484119011762 },
            { -1.58966906957485254459, 0.58996975014221642031, -44.99431096332273227745, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, -90,
            { -2.24612766651409989649, -0.99922666842209439952, -89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
            { -2.24612766651347328661, -0.99922666842209439952, -89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
            { -2.24612766651409945240, -0.99922666842208529570, -89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 },
            { -2.24612766651409812013, -0.99922666841944873806, -89.96080977143354573400, 249935.55934300241642631590, 0.99922674685495815883 },
            { -2.24612766651407858021, -0.99922666842209184601, -89.96080977150054991398, 249935.55891566007630899549, 0.99922674685767387537 },
            { -2.24864304714222296155, -0.99923012194947846698, -89.96076583819413485799, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, -135,
            { -1.58943065821228057821, -2.59810442478829362045, -134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
            { -1.58943065821171258811, -2.59810442478739078709, -134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
            { -1.58943065613921019619, -2.59810442273856878614, -134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 },
            { -1.58943065729835319999, -2.59810443328209572655, -134.95009296210329807764, 249935.56090466637397184968, 0.99922675155085038945 },
            { -1.58943065821226814371, -2.59810442478831138402, -134.95009296248679220298, 249935.55953712956397794187, 0.99922675155892148879 },
            { -1.59120965314639395416, -2.58919942720575324557, -134.95016080642784572774, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, -1 }, 250000, -180,
            { 0.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { -0.00000000000000027540, -3.26088938009322193423, -180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { 0.00000000000000000000, -3.26088936183515265554, -180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { 0.00000000000000000000, -3.26088938879229361945, -180.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { 0.00000000000000000000, -3.26088938011400975014, -180.00000000000000000000, 249935.55991249711951240897, 0.99922675429255336521 },
            { 0.00000000000000000000, -3.24830091939884901819, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, 0,
            { 0.00000000000000000000, 3.26088938011404927408, 0.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { 0.00000000000000000000, 3.26088938009322193423, 0.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { 0.00000000000000000000, 3.26088936183515265554, 0.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { 0.00000000000000000000, 3.26088938879229361945, 0.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { 0.00000000000000000000, 3.26088938011400220063, 0.00000000000000000000, 249935.55991249639191664755, 0.99922675429255336521 },
            { 0.00000000000000000000, 3.24830091939884457730, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, 45,
            { 1.58943065821228057821, 2.59810442478829362045, 45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
            { 1.58943065821171236607, 2.59810442478739123118, 45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
            { 1.58943065613921019619, 2.59810442273856923023, 45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 },
            { 1.58943065729835319999, 2.59810443328209572655, 45.04990703789670902779, 249935.56090466640307568014, 0.99922675155085038945 },
            { 1.58943065821227924594, 2.59810442478829228818, 45.04990703751319358616, 249935.55953712644986808300, 0.99922675155892171084 },
            { 1.59120965314638773691, 2.58919942720574303152, 45.04983919357213295598, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, 90,
            { 2.24612766651409989649, 0.99922666842209439952, 90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
            { 2.24612766651347328661, 0.99922666842209484361, 90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
            { 2.24612766651409945240, 0.99922666842208562876, 90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 },
            { 2.24612766651409812013, 0.99922666841944918215, 90.03919022856645426600, 249935.55934300230001099408, 0.99922674685495815883 },
            { 2.24612766651412920638, 0.99922666842209206806, 90.03919022849945008602, 249935.55891566010541282594, 0.99922674685767398639 },
            { 2.24864304714222296155, 0.99923012194947880005, 90.03923416180586514201, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, 135,
            { 1.58789352027561725400, -0.59889382252477618707, 135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
            { 1.58789352027508301468, -0.59889382252384604222, 135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
            { 1.58789351816042789700, -0.59889382039736038799, 135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 },
            { 1.58789351933467837164, -0.59889382227058296504, 135.00555901266275782291, 249935.55866038758540526032, 0.99922674484142481877 },
            { 1.58789352027559971248, -0.59889382252475087398, 135.00555901266014302564, 249935.55869721240014769137, 0.99922674484119011762 },
            { 1.58966906957488163243, -0.58996975014221753053, 135.00568903667726772255, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, 180,
            { 0.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { 0.00000000000000027502, -1.26092062916373448545, 180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { 0.00000000000000000000, -1.26092061053506587776, 180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { 0.00000000000000000000, -1.26092062023552875516, 180.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { 0.00000000000000000000, -1.26092062918495328994, 180.00000000000000000000, 249935.55872469520545564592, 0.99922674479230122468 },
            { 0.00000000000000000000, -1.24830091939885789998, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, -45,
            { -1.58943065821228057821, 2.59810442478829362045, -45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
            { -1.58943065821171236607, 2.59810442478739123118, -45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
            { -1.58943065613921019619, 2.59810442273856923023, -45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 },
            { -1.58943065729835319999, 2.59810443328209572655, -45.04990703789670902779, 249935.56090466640307568014, 0.99922675155085038945 },
            { -1.58943065821227924594, 2.59810442478829228818, -45.04990703751319358616, 249935.55953712644986808300, 0.99922675155892171084 },
            { -1.59120965314638773691, 2.58919942720574303152, -45.04983919357213295598, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, -90,
            { -2.24612766651409989649, 0.99922666842209439952, -90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
            { -2.24612766651347328661, 0.99922666842209484361, -90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
            { -2.24612766651409945240, 0.99922666842208562876, -90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 },
            { -2.24612766651409812013, 0.99922666841944918215, -90.03919022856645426600, 249935.55934300230001099408, 0.99922674685495815883 },
            { -2.24612766651412920638, 0.99922666842209206806, -90.03919022849945008602, 249935.55891566010541282594, 0.99922674685767398639 },
            { -2.24864304714222296155, 0.99923012194947880005, -90.03923416180586514201, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, -135,
            { -1.58789352027561725400, -0.59889382252477618707, -135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
            { -1.58789352027508301468, -0.59889382252384604222, -135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
            { -1.58789351816042789700, -0.59889382039736038799, -135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 },
            { -1.58789351933467837164, -0.59889382227058296504, -135.00555901266275782291, 249935.55866038758540526032, 0.99922674484142481877 },
            { -1.58789352027559971248, -0.59889382252475087398, -135.00555901266014302564, 249935.55869721240014769137, 0.99922674484119011762 },
            { -1.58966906957488163243, -0.58996975014221753053, -135.00568903667726772255, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 0, 1 }, 250000, -180,
            { 0.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { -0.00000000000000027502, -1.26092062916373448545, -180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { 0.00000000000000000000, -1.26092061053506587776, -180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { 0.00000000000000000000, -1.26092062023552875516, -180.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { 0.00000000000000000000, -1.26092062918495328994, -180.00000000000000000000, 249935.55872469520545564592, 0.99922674479230122468 },
            { 0.00000000000000000000, -1.24830091939885789998, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, 0,
            { -1.00000000000000000000, 1.26092062918498104551, 0.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { -1.00000000000000000000, 1.26092062916373448545, 0.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { -1.00000000000000000000, 1.26092061053506587776, 0.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { -1.00000000000000000000, 1.26092062023552875516, 0.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { -1.00000000000000000000, 1.26092062918495995127, 0.00000000000000000000, 249935.55872469596215523779, 0.99922674479230122468 },
            { -1.00000000000000000000, 1.24830091939884435526, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, 45,
            { 0.58789352027561725400, 0.59889382252477618707, 44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
            { 0.58789352027508279264, 0.59889382252384637528, 44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
            { 0.58789351816042800802, 0.59889382039736038799, 44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 },
            { 0.58789351933467837164, 0.59889382227058296504, 44.99444098733723507166, 249935.55866038752719759941, 0.99922674484142481877 },
            { 0.58789352027561669889, 0.59889382252477563195, 44.99444098733987829064, 249935.55869721624185331166, 0.99922674484119011762 },
            { 0.58966906957485232255, 0.58996975014221642031, 44.99431096332273227745, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, 90,
            { 1.24612766651409989649, -0.99922666842209439952, 89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
            { 1.24612766651347328661, -0.99922666842209439952, 89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
            { 1.24612766651409945240, -0.99922666842208529570, 89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 },
            { 1.24612766651409834218, -0.99922666841944873806, 89.96080977143354573400, 249935.55934300241642631590, 0.99922674685495815883 },
            { 1.24612766651407835816, -0.99922666842209184601, 89.96080977150054991398, 249935.55891566007630899549, 0.99922674685767387537 },
            { 1.24864304714222140724, -0.99923012194947846698, 89.96076583819413485799, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, 135,
            { 0.58943065821228057821, -2.59810442478829362045, 134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
            { 0.58943065821171258811, -2.59810442478739078709, 134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
            { 0.58943065613921030721, -2.59810442273856878614, 134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 },
            { 0.58943065729835331101, -2.59810443328209572655, 134.95009296210329807764, 249935.56090466637397184968, 0.99922675155085038945 },
            { 0.58943065821226814371, -2.59810442478831138402, 134.95009296248679220298, 249935.55953712956397794187, 0.99922675155892148879 },
            { 0.59120965314640527843, -2.58919942720575324557, 134.95016080642784572774, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, 180,
            { -1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { -0.99999999999999977796, -3.26088938009322193423, 180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { -1.00000000000000000000, -3.26088936183515265554, 180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { -1.00000000000000000000, -3.26088938879229361945, 180.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { -1.00000000000000000000, -3.26088938011400975014, 180.00000000000000000000, 249935.55991249711951240897, 0.99922675429255336521 },
            { -0.99999999999998867573, -3.24830091939884901819, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, -45,
            { -2.58789352027561747605, 0.59889382252477618707, -44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
            { -2.58789352027508279264, 0.59889382252384637528, -44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
            { -2.58789351816042811905, 0.59889382039736038799, -44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 },
            { -2.58789351933467859368, 0.59889382227058296504, -44.99444098733723507166, 249935.55866038752719759941, 0.99922674484142481877 },
            { -2.58789352027561658787, 0.59889382252477563195, -44.99444098733987829064, 249935.55869721624185331166, 0.99922674484119011762 },
            { -2.58966906957485276664, 0.58996975014221642031, -44.99431096332273227745, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, -90,
            { -3.24612766651409989649, -0.99922666842209439952, -89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
            { -3.24612766651347328661, -0.99922666842209439952, -89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
            { -3.24612766651409989649, -0.99922666842208529570, -89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 },
            { -3.24612766651409812013, -0.99922666841944873806, -89.96080977143354573400, 249935.55934300241642631590, 0.99922674685495815883 },
            { -3.24612766651407813612, -0.99922666842209184601, -89.96080977150054991398, 249935.55891566007630899549, 0.99922674685767387537 },
            { -3.24864304714222429382, -0.99923012194947846698, -89.96076583819413485799, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, -135,
            { -2.58943065821228035617, -2.59810442478829362045, -134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
            { -2.58943065821171281016, -2.59810442478739078709, -134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
            { -2.58943065613921019619, -2.59810442273856878614, -134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 },
            { -2.58943065729835319999, -2.59810443328209572655, -134.95009296210329807764, 249935.56090466637397184968, 0.99922675155085038945 },
            { -2.58943065821226792167, -2.59810442478831138402, -134.95009296248679220298, 249935.55953712956397794187, 0.99922675155892148879 },
            { -2.59120965314638285193, -2.58919942720575324557, -134.95016080642784572774, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, -1 }, 250000, -180,
            { -1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { -1.00000000000000022204, -3.26088938009322193423, -180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { -1.00000000000000000000, -3.26088936183515265554, -180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { -1.00000000000000000000, -3.26088938879229361945, -180.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { -1.00000000000000000000, -3.26088938011400975014, -180.00000000000000000000, 249935.55991249711951240897, 0.99922675429255336521 },
            { -0.99999999999998867573, -3.24830091939884901819, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, 0,
            { -1.00000000000000000000, 3.26088938011404927408, 0.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { -1.00000000000000000000, 3.26088938009322193423, 0.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { -1.00000000000000000000, 3.26088936183515265554, 0.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { -1.00000000000000000000, 3.26088938879229361945, 0.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { -1.00000000000000000000, 3.26088938011400220063, 0.00000000000000000000, 249935.55991249639191664755, 0.99922675429255336521 },
            { -1.00000000000000000000, 3.24830091939884457730, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, 45,
            { 0.58943065821228057821, 2.59810442478829362045, 45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
            { 0.58943065821171236607, 2.59810442478739123118, 45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
            { 0.58943065613921030721, 2.59810442273856923023, 45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 },
            { 0.58943065729835331101, 2.59810443328209572655, 45.04990703789670902779, 249935.56090466640307568014, 0.99922675155085038945 },
            { 0.58943065821227913492, 2.59810442478829228818, 45.04990703751319358616, 249935.55953712644986808300, 0.99922675155892171084 },
            { 0.59120965314638784793, 2.58919942720574303152, 45.04983919357213295598, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, 90,
            { 1.24612766651409989649, 0.99922666842209439952, 90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
            { 1.24612766651347328661, 0.99922666842209484361, 90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
            { 1.24612766651409945240, 0.99922666842208562876, 90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 },
            { 1.24612766651409834218, 0.99922666841944918215, 90.03919022856645426600, 249935.55934300230001099408, 0.99922674685495815883 },
            { 1.24612766651412942842, 0.99922666842209206806, 90.03919022849945008602, 249935.55891566010541282594, 0.99922674685767398639 },
            { 1.24864304714222140724, 0.99923012194947880005, 90.03923416180586514201, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, 135,
            { 0.58789352027561725400, -0.59889382252477618707, 135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
            { 0.58789352027508301468, -0.59889382252384604222, 135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
            { 0.58789351816042800802, -0.59889382039736038799, 135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 },
            { 0.58789351933467837164, -0.59889382227058296504, 135.00555901266275782291, 249935.55866038758540526032, 0.99922674484142481877 },
            { 0.58789352027559971248, -0.59889382252475087398, 135.00555901266014302564, 249935.55869721240014769137, 0.99922674484119011762 },
            { 0.58966906957488163243, -0.58996975014221753053, 135.00568903667726772255, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, 180,
            { -1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { -0.99999999999999977796, -1.26092062916373448545, 180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { -1.00000000000000000000, -1.26092061053506587776, 180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { -1.00000000000000000000, -1.26092062023552875516, 180.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { -1.00000000000000000000, -1.26092062918495328994, 180.00000000000000000000, 249935.55872469520545564592, 0.99922674479230122468 },
            { -1.00000000000000000000, -1.24830091939885789998, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, -45,
            { -2.58943065821228035617, 2.59810442478829362045, -45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
            { -2.58943065821171236607, 2.59810442478739123118, -45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
            { -2.58943065613921019619, 2.59810442273856923023, -45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 },
            { -2.58943065729835319999, 2.59810443328209572655, -45.04990703789670902779, 249935.56090466640307568014, 0.99922675155085038945 },
            { -2.58943065821227902390, 2.59810442478829228818, -45.04990703751319358616, 249935.55953712644986808300, 0.99922675155892171084 },
            { -2.59120965314638818100, 2.58919942720574303152, -45.04983919357213295598, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, -90,
            { -3.24612766651409989649, 0.99922666842209439952, -90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
            { -3.24612766651347328661, 0.99922666842209484361, -90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
            { -3.24612766651409989649, 0.99922666842208562876, -90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 },
            { -3.24612766651409812013, 0.99922666841944918215, -90.03919022856645426600, 249935.55934300230001099408, 0.99922674685495815883 },
            { -3.24612766651412920638, 0.99922666842209206806, -90.03919022849945008602, 249935.55891566010541282594, 0.99922674685767398639 },
            { -3.24864304714222429382, 0.99923012194947880005, -90.03923416180586514201, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, -135,
            { -2.58789352027561747605, -0.59889382252477618707, -135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
            { -2.58789352027508279264, -0.59889382252384604222, -135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
            { -2.58789351816042811905, -0.59889382039736038799, -135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 },
            { -2.58789351933467859368, -0.59889382227058296504, -135.00555901266275782291, 249935.55866038758540526032, 0.99922674484142481877 },
            { -2.58789352027559971248, -0.59889382252475087398, -135.00555901266014302564, 249935.55869721240014769137, 0.99922674484119011762 },
            { -2.58966906957482478902, -0.58996975014221753053, -135.00568903667726772255, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { -1, 1 }, 250000, -180,
            { -1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { -1.00000000000000022204, -1.26092062916373448545, -180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { -1.00000000000000000000, -1.26092061053506587776, -180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { -1.00000000000000000000, -1.26092062023552875516, -180.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { -1.00000000000000000000, -1.26092062918495328994, -180.00000000000000000000, 249935.55872469520545564592, 0.99922674479230122468 },
            { -1.00000000000000000000, -1.24830091939885789998, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, 0,
            { 1.00000000000000000000, 3.26088938011404927408, 0.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { 1.00000000000000000000, 3.26088938009322193423, 0.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { 1.00000000000000000000, 3.26088936183515265554, 0.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { 1.00000000000000000000, 3.26088938879229361945, 0.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { 1.00000000000000000000, 3.26088938011400220063, 0.00000000000000000000, 249935.55991249639191664755, 0.99922675429255336521 },
            { 1.00000000000000000000, 3.24830091939884457730, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, 45,
            { 2.58943065821228035617, 2.59810442478829362045, 45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
            { 2.58943065821171236607, 2.59810442478739123118, 45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
            { 2.58943065613921019619, 2.59810442273856923023, 45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 },
            { 2.58943065729835319999, 2.59810443328209572655, 45.04990703789670902779, 249935.56090466640307568014, 0.99922675155085038945 },
            { 2.58943065821227902390, 2.59810442478829228818, 45.04990703751319358616, 249935.55953712644986808300, 0.99922675155892171084 },
            { 2.59120965314638818100, 2.58919942720574303152, 45.04983919357213295598, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, 90,
            { 3.24612766651409989649, 0.99922666842209439952, 90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
            { 3.24612766651347328661, 0.99922666842209484361, 90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
            { 3.24612766651409989649, 0.99922666842208562876, 90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 },
            { 3.24612766651409812013, 0.99922666841944918215, 90.03919022856645426600, 249935.55934300230001099408, 0.99922674685495815883 },
            { 3.24612766651412920638, 0.99922666842209206806, 90.03919022849945008602, 249935.55891566010541282594, 0.99922674685767398639 },
            { 3.24864304714222429382, 0.99923012194947880005, 90.03923416180586514201, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, 135,
            { 2.58789352027561747605, -0.59889382252477618707, 135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
            { 2.58789352027508279264, -0.59889382252384604222, 135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
            { 2.58789351816042811905, -0.59889382039736038799, 135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 },
            { 2.58789351933467859368, -0.59889382227058296504, 135.00555901266275782291, 249935.55866038758540526032, 0.99922674484142481877 },
            { 2.58789352027559971248, -0.59889382252475087398, 135.00555901266014302564, 249935.55869721240014769137, 0.99922674484119011762 },
            { 2.58966906957482478902, -0.58996975014221753053, 135.00568903667726772255, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, 180,
            { 1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { 1.00000000000000022204, -1.26092062916373448545, 180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { 1.00000000000000000000, -1.26092061053506587776, 180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { 1.00000000000000000000, -1.26092062023552875516, 180.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { 1.00000000000000000000, -1.26092062918495328994, 180.00000000000000000000, 249935.55872469520545564592, 0.99922674479230122468 },
            { 1.00000000000000000000, -1.24830091939885789998, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, -45,
            { -0.58943065821228057821, 2.59810442478829362045, -45.04990703751319358616, 249935.55953696221695281565, 0.99922675155892082266 },
            { -0.58943065821171236607, 2.59810442478739123118, -45.04990703751315805903, 249935.55953448649961501360, 0.99922675162094765078 },
            { -0.58943065613921030721, 2.59810442273856923023, -45.04990703742064539483, 249935.55921406255220063031, 0.99922675162293117523 },
            { -0.58943065729835331101, 2.59810443328209572655, -45.04990703789670902779, 249935.56090466640307568014, 0.99922675155085038945 },
            { -0.58943065821227913492, 2.59810442478829228818, -45.04990703751319358616, 249935.55953712644986808300, 0.99922675155892171084 },
            { -0.59120965314638784793, 2.58919942720574303152, -45.04983919357213295598, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, -90,
            { -1.24612766651409989649, 0.99922666842209439952, -90.03919022849945008602, 249935.55891569345840252936, 0.99922674685767398639 },
            { -1.24612766651347328661, 0.99922666842209484361, -90.03919022849945008602, 249935.55891513981623575091, 0.99922674686822765544 },
            { -1.24612766651409945240, 0.99922666842208562876, -90.03919022849967745969, 249935.55891660030465573072, 0.99922674686821866263 },
            { -1.24612766651409834218, 0.99922666841944918215, -90.03919022856645426600, 249935.55934300230001099408, 0.99922674685495815883 },
            { -1.24612766651412942842, 0.99922666842209206806, -90.03919022849945008602, 249935.55891566010541282594, 0.99922674685767398639 },
            { -1.24864304714222140724, 0.99923012194947880005, -90.03923416180586514201, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, -135,
            { -0.58789352027561725400, -0.59889382252477618707, -135.00555901266011460393, 249935.55869720416376367211, 0.99922674484119022864 },
            { -0.58789352027508301468, -0.59889382252384604222, -135.00555901266014302564, 249935.55869934437214396894, 0.99922674484277662632 },
            { -0.58789351816042800802, -0.59889382039736038799, -135.00555901268222669387, 249935.55836710284347645938, 0.99922674484483320345 },
            { -0.58789351933467837164, -0.59889382227058296504, -135.00555901266275782291, 249935.55866038758540526032, 0.99922674484142481877 },
            { -0.58789352027559971248, -0.59889382252475087398, -135.00555901266014302564, 249935.55869721240014769137, 0.99922674484119011762 },
            { -0.58966906957488163243, -0.58996975014221753053, -135.00568903667726772255, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, 1 }, 250000, -180,
            { 1.00000000000000000000, -1.26092062918498104551, -180.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { 0.99999999999999977796, -1.26092062916373448545, -180.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { 1.00000000000000000000, -1.26092061053506587776, -180.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { 1.00000000000000000000, -1.26092062023552875516, -180.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { 1.00000000000000000000, -1.26092062918495328994, -180.00000000000000000000, 249935.55872469520545564592, 0.99922674479230122468 },
            { 1.00000000000000000000, -1.24830091939885789998, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, 0,
            { 1.00000000000000000000, 1.26092062918498104551, 0.00000000000000000000, 249935.55872467698645778000, 0.99922674479230122468 },
            { 1.00000000000000000000, 1.26092062916373448545, 0.00000000000000000000, 249935.55872643628390505910, 0.99922674479075712650 },
            { 1.00000000000000000000, 1.26092061053506587776, 0.00000000000000000000, 249935.55666816755547188222, 0.99922674480349771287 },
            { 1.00000000000000000000, 1.26092062023552875516, 0.00000000000000000000, 249935.55774092715000733733, 0.99922674479840822848 },
            { 1.00000000000000000000, 1.26092062918495995127, 0.00000000000000000000, 249935.55872469596215523779, 0.99922674479230122468 },
            { 1.00000000000000000000, 1.24830091939884435526, 0.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, 45,
            { 2.58789352027561747605, 0.59889382252477618707, 44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
            { 2.58789352027508279264, 0.59889382252384637528, 44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
            { 2.58789351816042811905, 0.59889382039736038799, 44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 },
            { 2.58789351933467859368, 0.59889382227058296504, 44.99444098733723507166, 249935.55866038752719759941, 0.99922674484142481877 },
            { 2.58789352027561658787, 0.59889382252477563195, 44.99444098733987829064, 249935.55869721624185331166, 0.99922674484119011762 },
            { 2.58966906957485276664, 0.58996975014221642031, 44.99431096332273227745, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, 90,
            { 3.24612766651409989649, -0.99922666842209439952, 89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
            { 3.24612766651347328661, -0.99922666842209439952, 89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
            { 3.24612766651409989649, -0.99922666842208529570, 89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 },
            { 3.24612766651409812013, -0.99922666841944873806, 89.96080977143354573400, 249935.55934300241642631590, 0.99922674685495815883 },
            { 3.24612766651407813612, -0.99922666842209184601, 89.96080977150054991398, 249935.55891566007630899549, 0.99922674685767387537 },
            { 3.24864304714222429382, -0.99923012194947846698, 89.96076583819413485799, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, 135,
            { 2.58943065821228035617, -2.59810442478829362045, 134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
            { 2.58943065821171281016, -2.59810442478739078709, 134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
            { 2.58943065613921019619, -2.59810442273856878614, 134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 },
            { 2.58943065729835319999, -2.59810443328209572655, 134.95009296210329807764, 249935.56090466637397184968, 0.99922675155085038945 },
            { 2.58943065821226792167, -2.59810442478831138402, 134.95009296248679220298, 249935.55953712956397794187, 0.99922675155892148879 },
            { 2.59120965314638285193, -2.58919942720575324557, 134.95016080642784572774, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, 180,
            { 1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { 1.00000000000000022204, -3.26088938009322193423, 180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { 1.00000000000000000000, -3.26088936183515265554, 180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { 1.00000000000000000000, -3.26088938879229361945, 180.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { 1.00000000000000000000, -3.26088938011400975014, 180.00000000000000000000, 249935.55991249711951240897, 0.99922675429255336521 },
            { 0.99999999999998867573, -3.24830091939884901819, 180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, -45,
            { -0.58789352027561725400, 0.59889382252477618707, -44.99444098733987829064, 249935.55869720416376367211, 0.99922674484119022864 },
            { -0.58789352027508279264, 0.59889382252384637528, -44.99444098733987118521, 249935.55869934445945546031, 0.99922674484277662632 },
            { -0.58789351816042800802, 0.59889382039736038799, -44.99444098731778751699, 249935.55836710281437262893, 0.99922674484483320345 },
            { -0.58789351933467837164, 0.59889382227058296504, -44.99444098733723507166, 249935.55866038752719759941, 0.99922674484142481877 },
            { -0.58789352027561669889, 0.59889382252477563195, -44.99444098733987829064, 249935.55869721624185331166, 0.99922674484119011762 },
            { -0.58966906957485232255, 0.58996975014221642031, -44.99431096332273227745, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, -90,
            { -1.24612766651409989649, -0.99922666842209439952, -89.96080977150054991398, 249935.55891569345840252936, 0.99922674685767398639 },
            { -1.24612766651347328661, -0.99922666842209439952, -89.96080977150054991398, 249935.55891513984533958137, 0.99922674686822765544 },
            { -1.24612766651409945240, -0.99922666842208529570, -89.96080977150032254031, 249935.55891660030465573072, 0.99922674686821844059 },
            { -1.24612766651409834218, -0.99922666841944873806, -89.96080977143354573400, 249935.55934300241642631590, 0.99922674685495815883 },
            { -1.24612766651407835816, -0.99922666842209184601, -89.96080977150054991398, 249935.55891566007630899549, 0.99922674685767387537 },
            { -1.24864304714222140724, -0.99923012194947846698, -89.96076583819413485799, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, -135,
            { -0.58943065821228057821, -2.59810442478829362045, -134.95009296248679220298, 249935.55953696221695281565, 0.99922675155892082266 },
            { -0.58943065821171258811, -2.59810442478739078709, -134.95009296248684904640, 249935.55953448649961501360, 0.99922675162094776180 },
            { -0.58943065613921030721, -2.59810442273856878614, -134.95009296257936171060, 249935.55921406237757764757, 0.99922675162293117523 },
            { -0.58943065729835331101, -2.59810443328209572655, -134.95009296210329807764, 249935.56090466637397184968, 0.99922675155085038945 },
            { -0.58943065821226814371, -2.59810442478831138402, -134.95009296248679220298, 249935.55953712956397794187, 0.99922675155892148879 },
            { -0.59120965314640527843, -2.58919942720575324557, -134.95016080642784572774, 0.00000000000000000000, 1.00000000000000000000 }
        },{
            { 1, -1 }, 250000, -180,
            { 1.00000000000000000000, -3.26088938011404927408, -180.00000000000000000000, 249935.55991226507467217743, 0.99922675429255258805 },
            { 0.99999999999999977796, -3.26088938009322193423, -180.00000000000000000000, 249935.55988221566076390445, 0.99922675435769237051 },
            { 1.00000000000000000000, -3.26088936183515265554, -180.00000000000000000000, 249935.55786483851261436939, 0.99922675437017982603 },
            { 1.00000000000000000000, -3.26088938879229361945, -180.00000000000000000000, 249935.56092769638053141534, 0.99922675428677187881 },
            { 1.00000000000000000000, -3.26088938011400975014, -180.00000000000000000000, 249935.55991249711951240897, 0.99922675429255336521 },
            { 0.99999999999998867573, -3.24830091939884901819, -180.00000000000000000000, 0.00000000000000000000, 1.00000000000000000000 }
        }

};

size_t const expected_size = sizeof(expected) / sizeof(expected_results);
#endif // BOOST_GEOMETRY_TEST_DIRECT_CASES_HPP
