/* Link testing for outcomes
(C) 2024 Niall Douglas <http://www.nedproductions.biz/> (6 commits)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include "lib.h"

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(void)
{
  mylib_result r = test_function(5);
  if(is_result_failed(r))
  {
    fprintf(stderr, "FATAL: test_function(5) failed with '%s'\n", result_failure_message(r));
    abort();
  }
  if(r.value != 5)
  {
    fprintf(stderr, "FATAL: test_function(5) did not return 5\n");
    abort();
  }
  r = test_function(-5);
  if(!is_result_failed(r))
  {
    fprintf(stderr, "FATAL: test_function(-5) did not fail\n");
    abort();
  }
  const char *msg = result_failure_message(r);
  printf("test_function(-5) should fail with 'Invalid argument'\nIt failed with '%s'\n", msg);
  if(0 != strcmp(msg, "Invalid argument"))
  {
    abort();
  }
  return 0;
}