# Official design
vcpkg_check_linkage(ONLY_DYNAMIC_LIBRARY)

vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO libfann/fann
    REF 2.2.0
    SHA512 b307539a39d93078a489710ac77aa8c6e324f3cf5ef80299ce257d10c043913764abef83aceac5278a5bd243b1ee245b4e8331a9e13c774aa63c9cb604f86bdd
    HEAD_REF master
    PATCHES
        fix-installation.patch
        fix-uwp-build.patch
)

set(INSTALL_BASE_DIR_DBG ${CURRENT_PACKAGES_DIR}/debug)
set(INSTALL_BASE_DIR_REL ${CURRENT_PACKAGES_DIR})

vcpkg_configure_cmake(
    SOURCE_PATH ${SOURCE_PATH}
    PREFER_NINJA
    OPTIONS_DEBUG
        -DBIN_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/bin
        -DSBIN_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/sbin
        -DLIB_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/bin
        -DEXEC_INSTALL_PREFIX=${INSTALL_BASE_DIR_DBG}/tools/${PORT}
        -DXDG_APPS_DIR=${INSTALL_BASE_DIR_DBG}/tools/${PORT}
        -DPLUGIN_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/tools/${PORT}
        -DSHARE_INSTALL_PREFIX=${INSTALL_BASE_DIR_DBG}/share/${PORT}
        -DDATA_INSTALL_PREFIX=${INSTALL_BASE_DIR_DBG}/share/${PORT}
        -DHTML_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/share/${PORT}/doc
        -DICON_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/share/${PORT}/data/icons
        -DSOUND_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/share/${PORT}/sounds
        -DLOCALE_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/share/${PORT}/locale
        -DSYSCONF_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/share/${PORT}/etc
        -DINFO_INSTALL_DIR=${INSTALL_BASE_DIR_DBG}/share/${PORT}/info
    OPTIONS_RELEASE
        -DBIN_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/bin
        -DSBIN_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/sbin
        -DLIB_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/bin
        -DEXEC_INSTALL_PREFIX=${INSTALL_BASE_DIR_REL}/tools/${PORT}
        -DXDG_APPS_DIR=${INSTALL_BASE_DIR_REL}/tools/${PORT}
        -DPLUGIN_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/tools/${PORT}
        -DSHARE_INSTALL_PREFIX=${INSTALL_BASE_DIR_REL}/share/${PORT}
        -DDATA_INSTALL_PREFIX=${INSTALL_BASE_DIR_REL}/share/${PORT}
        -DHTML_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/share/${PORT}/doc
        -DICON_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/share/${PORT}/data/icons
        -DSOUND_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/share/${PORT}/sounds
        -DLOCALE_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/share/${PORT}/locale
        -DSYSCONF_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/share/${PORT}/etc
        -DINFO_INSTALL_DIR=${INSTALL_BASE_DIR_REL}/share/${PORT}/info
)

vcpkg_install_cmake()

vcpkg_copy_pdbs()

vcpkg_fixup_pkgconfig()

file(REMOVE_RECURSE ${CURRENT_PACKAGES_DIR}/debug/include)

file(INSTALL ${SOURCE_PATH}/COPYING.txt DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)